/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx;

import java.nio.charset.Charset;
import jpcsp.format.rco.vsmx.VSMXCode;
import jpcsp.format.rco.vsmx.VSMXDecompiler;
import jpcsp.format.rco.vsmx.VSMXGroup;
import jpcsp.format.rco.vsmx.VSMXHeader;
import jpcsp.format.rco.vsmx.VSMXMem;
import org.apache.log4j.Logger;

public class VSMX {
    public static Logger log = Logger.getLogger((String)"vsmx");
    private static final int VSMX_SIGNATURE = 1481462614;
    private static final int VSMX_VERSION = 65536;
    private byte[] buffer;
    private int offset;
    private VSMXHeader header;
    private VSMXMem mem;
    private String name;

    public VSMXMem getMem() {
        return this.mem;
    }

    private int read8() {
        return this.buffer[this.offset++] & 0xFF;
    }

    private int read16() {
        return this.read8() | this.read8() << 8;
    }

    private int read32() {
        return this.read16() | this.read16() << 16;
    }

    private void read(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)this.read8();
        }
    }

    private void seek(int offset) {
        this.offset = offset;
    }

    public VSMX(byte[] buffer, String name) {
        this.buffer = buffer;
        this.name = name;
        this.read();
    }

    public String getName() {
        return this.name;
    }

    private void readHeader() {
        this.header = new VSMXHeader();
        this.header.sig = this.read32();
        this.header.ver = this.read32();
        this.header.codeOffset = this.read32();
        this.header.codeLength = this.read32();
        this.header.textOffset = this.read32();
        this.header.textLength = this.read32();
        this.header.textEntries = this.read32();
        this.header.propOffset = this.read32();
        this.header.propLength = this.read32();
        this.header.propEntries = this.read32();
        this.header.namesOffset = this.read32();
        this.header.namesLength = this.read32();
        this.header.namesEntries = this.read32();
    }

    private static boolean isZero(byte[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (buffer[offset + i] == 0) continue;
            return false;
        }
        return true;
    }

    private String[] readStrings(int stringsOffset, int length, int entries, Charset charset, int bytesPerChar) {
        String[] strings = new String[entries];
        int stringIndex = 0;
        byte[] buffer = new byte[length];
        this.seek(stringsOffset);
        this.read(buffer);
        int stringStart = 0;
        for (int i = 0; i < length; i += bytesPerChar) {
            if (!VSMX.isZero(buffer, i, bytesPerChar)) continue;
            String s = new String(buffer, stringStart, i - stringStart, charset);
            stringStart = i + bytesPerChar;
            strings[stringIndex++] = s;
        }
        if (stringIndex != entries) {
            log.warn((Object)String.format("readStrings: incorrect number of strings read: stringsOffset=0x%X, length=0x%X, entries=0x%X, bytesPerChar=%d, read entries=0x%X", stringsOffset, length, entries, bytesPerChar, stringIndex));
        }
        return strings;
    }

    private void read() {
        this.readHeader();
        if (this.header.sig != 1481462614) {
            log.warn((Object)String.format("Invalid VSMX signature 0x%08X", this.header.sig));
            return;
        }
        if (this.header.ver != 65536) {
            log.warn((Object)String.format("Invalid VSMX version 0x%08X", this.header.ver));
            return;
        }
        if (this.header.codeOffset > this.header.size()) {
            log.warn((Object)String.format("VSMX: skipping range after header: 0x%X-0x%X", this.header.size(), this.header.codeOffset));
            this.seek(this.header.codeOffset);
        }
        if (this.header.codeLength % 8 != 0) {
            log.warn((Object)String.format("VSMX: code length is not aligned to 8 bytes: 0x%X", this.header.codeLength));
        }
        this.mem = new VSMXMem();
        this.mem.codes = new VSMXGroup[this.header.codeLength / 8];
        for (int i = 0; i < this.mem.codes.length; ++i) {
            this.mem.codes[i] = new VSMXGroup();
            this.mem.codes[i].id = this.read32();
            this.mem.codes[i].value = this.read32();
        }
        this.mem.texts = this.readStrings(this.header.textOffset, this.header.textLength, this.header.textEntries, Charset.forName("UTF-16LE"), 2);
        this.mem.properties = this.readStrings(this.header.propOffset, this.header.propLength, this.header.propEntries, Charset.forName("UTF-16LE"), 2);
        this.mem.names = this.readStrings(this.header.namesOffset, this.header.namesLength, this.header.namesEntries, Charset.forName("ISO-8859-1"), 1);
        if (log.isDebugEnabled()) {
            this.debug();
        }
    }

    public void debug() {
        for (int i = 0; i < this.mem.codes.length; ++i) {
            StringBuilder s = new StringBuilder();
            VSMXGroup code = this.mem.codes[i];
            int opcode = code.id & 0xFF;
            if (opcode >= 0 && opcode < VSMXCode.VsmxDecOps.length) {
                s.append(VSMXCode.VsmxDecOps[opcode]);
            } else {
                s.append(String.format("UNKNOWN_%X", opcode));
            }
            switch (opcode) {
                case 37: {
                    if (code.value == 1) {
                        s.append(" true");
                        break;
                    }
                    if (code.value == 0) {
                        s.append(" false");
                        break;
                    }
                    s.append(String.format(" 0x%X", code.value));
                    break;
                }
                case 38: 
                case 71: {
                    s.append(String.format(" %d", code.value));
                    break;
                }
                case 39: {
                    s.append(String.format(" %f", Float.valueOf(code.getFloatValue())));
                    break;
                }
                case 40: 
                case 70: {
                    s.append(String.format(" '%s'", this.mem.texts[code.value]));
                    break;
                }
                case 46: {
                    s.append(String.format(" %s", this.mem.names[code.value]));
                    break;
                }
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: {
                    s.append(String.format(" %s", this.mem.properties[code.value]));
                    break;
                }
                case 42: {
                    int n = code.id >> 16 & 0xFF;
                    if (n != 0) {
                        log.warn((Object)String.format("Unexpected localvars value for function at line %d, expected 0, got %d", i, n));
                    }
                    int args = code.id >> 8 & 0xFF;
                    int localVars = code.id >> 24 & 0xFF;
                    s.append(String.format(" args=%d, localVars=%d, startLine=%d", args, localVars, code.value));
                    break;
                }
                case 45: {
                    s.append(String.format(" %d", code.value));
                    break;
                }
                case 57: 
                case 58: 
                case 59: {
                    s.append(String.format(" line=%d", code.value));
                    break;
                }
                case 60: 
                case 61: 
                case 62: {
                    s.append(String.format(" args=%d", code.value));
                    break;
                }
                case 73: {
                    s.append(String.format(" items=%d", code.value));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 41: 
                case 43: 
                case 44: 
                case 52: 
                case 54: 
                case 56: 
                case 63: 
                case 69: {
                    if (code.value == 0) break;
                    log.warn((Object)String.format("Unexpected non-zero value at line #%d: 0x%X!", i, code.value));
                    break;
                }
                default: {
                    s.append(String.format(" 0x%X", code.value));
                }
            }
            log.debug((Object)String.format("Line#%d: %s", i, s.toString()));
        }
        log.debug((Object)this.decompile());
    }

    private String decompile() {
        VSMXDecompiler decompiler = new VSMXDecompiler(this);
        return decompiler.toString();
    }
}

